package com.elitesland.cbpl.rosefinch.vo.param;

import com.elitesland.yst.common.base.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import javax.validation.constraints.NotNull;
import java.io.Serial;

/**
 * @author eric.hao
 * @since 2022/06/21
 */
@ApiModel(description = "批处理日志查询")
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class RosefinchDetailPageParamVO extends AbstractOrderQueryParam {

    @Serial
    private static final long serialVersionUID = -6105525656825652361L;

    @ApiModelProperty("主表id")
    @NotNull(message = "参数错误：日志ID必传")
    private Long masId;

    @ApiModelProperty("日志行状态")
    private String logStatus;
}
