package com.elitesland.cbpl.rosefinch.vo.resp;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author eric.hao
 * @since 2022/06/20
 */
@Data
@ApiModel("日志明细")
public class RosefinchDetailRespVO implements Serializable {

    @Serial
    private static final long serialVersionUID = 3629604267558681557L;

    @ApiModelProperty("明细行id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("行号")
    private Integer lineNo;

    @ApiModelProperty("主表id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long masId;

    @ApiModelProperty("日志行状态")
    private String logStatus;

    @ApiModelProperty("错误信息")
    private String errorMsg;

    @ApiModelProperty("开始时间")
    private LocalDateTime startTime;

    @ApiModelProperty("结束时间")
    private LocalDateTime endTime;

    public LocalDateTime getCreateTime() {
        return startTime;
    }
}
