package com.elitesland.cbpl.unicom.context;

import lombok.Getter;

/**
 * @author eric.hao
 * @since 2022/03/21
 */
public enum Industry {

    /**
     * 行业标准编码
     */
    GENERAL("通用行业"),
    MEDICINAL("医药行业"),
    MANUFACTURE("制造行业"),
    CATERING("餐饮行业"),
    ;

    public String getCode() {
        return name();
    }

    @Getter
    private final String desc;

    Industry(String desc) {
        this.desc = desc;
    }

    public static Industry fromCode(String mode) {
        for (Industry e : Industry.values()) {
            if (e.getCode().equals(mode)) {
                return e;
            }
        }
        return GENERAL;
    }
}
