/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.elastic.repository;

import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.elastic.util.ElasticUtil;
import com.elitesland.yst.common.base.PagingVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;
import org.springframework.data.elasticsearch.core.RefreshPolicy;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.ByQueryResponse;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.stereotype.Component;

@Component
public class ElasticRepository {
    private static final Logger logger = LoggerFactory.getLogger(ElasticRepository.class);
    @Autowired
    private ElasticsearchRestTemplate elasticsearchRestTemplate;
    private static boolean ES_ENABLED;

    @PostConstruct
    public void enabled() {
        ES_ENABLED = ObjectUtil.isNotNull((Object)this.elasticsearchRestTemplate);
        logger.info("[PHOENIX-ES] elasticsearch serve available status: {}", (Object)ES_ENABLED);
        if (ES_ENABLED) {
            this.elasticsearchRestTemplate.setRefreshPolicy(RefreshPolicy.IMMEDIATE);
        }
    }

    public boolean existsIndex(String indexName) {
        return this.elasticsearchRestTemplate.indexOps(IndexCoordinates.of((String[])new String[]{indexName})).exists();
    }

    public boolean createIndex(String indexName) {
        if (this.existsIndex(indexName)) {
            return true;
        }
        boolean result = this.elasticsearchRestTemplate.indexOps(IndexCoordinates.of((String[])new String[]{indexName})).create();
        logger.info("[PHOENIX-ES] CREATE INDEX NAME({}) SUCCESS.", (Object)indexName);
        return result;
    }

    public boolean deleteIndex(String indexName) {
        if (!this.existsIndex(indexName)) {
            logger.warn("[PHOENIX-ES] INDEX NAME({}) NOT EXISTED.", (Object)indexName);
            return true;
        }
        boolean result = this.elasticsearchRestTemplate.indexOps(IndexCoordinates.of((String[])new String[]{indexName})).delete();
        logger.info("[PHOENIX-ES] DELETE INDEX({}) SUCCESS.", (Object)indexName);
        return result;
    }

    public <T> void insert(T data, String indexName) {
        if (this.createIndex(indexName)) {
            this.elasticsearchRestTemplate.save(data, IndexCoordinates.of((String[])new String[]{indexName}));
        }
    }

    public <T> void batchInsert(List<T> dataList, String indexName) {
        if (this.createIndex(indexName)) {
            ArrayList indexQueryList = new ArrayList();
            dataList.stream().map(ElasticUtil::indexQueryBuilder).forEach(indexQueryList::add);
            this.elasticsearchRestTemplate.bulkIndex(indexQueryList, IndexCoordinates.of((String[])new String[]{indexName}));
        }
    }

    public Long delete(String indexName, Class<?> clazz, String bizKey, List<String> bizValue) {
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)bizKey, bizValue));
        NativeSearchQuery query = new NativeSearchQueryBuilder().withQuery((QueryBuilder)boolQueryBuilder).build();
        ByQueryResponse resp = this.elasticsearchRestTemplate.delete((Query)query, clazz, IndexCoordinates.of((String[])new String[]{indexName}));
        logger.info("[PHOENIX-ES] DELETE index({}) bizKey({}) bizValue({}) SUCCESS.", new Object[]{indexName, bizKey, bizValue});
        return resp.getTotal();
    }

    public void deleteById(String id, String indexName) {
        if (ObjectUtil.isNotNull((Object)id) && StringUtils.isNotBlank((CharSequence)indexName)) {
            this.elasticsearchRestTemplate.delete(id, IndexCoordinates.of((String[])new String[]{indexName}));
            logger.info("[PHOENIX-ES] DELETE index({}) dataId({}) SUCCESS.", (Object)indexName, (Object)id);
        }
    }

    public <T extends Serializable> PagingVO<T> queryPaging(String indexName, Class<T> clazz, Query query) {
        SearchHits search = this.elasticsearchRestTemplate.search(query, clazz, IndexCoordinates.of((String[])new String[]{indexName}));
        if (search.getTotalHits() == 0L) {
            return new PagingVO();
        }
        List searchHits = search.getSearchHits();
        List<Serializable> list = searchHits.stream().map(SearchHit::getContent).toList();
        return new PagingVO(search.getTotalHits(), list);
    }

    public <T> List<T> queryList(String indexName, Class<T> clazz, NativeSearchQuery query) {
        SearchHits search = this.elasticsearchRestTemplate.search((Query)query, clazz, IndexCoordinates.of((String[])new String[]{indexName}));
        if (search.getTotalHits() == 0L) {
            return Collections.emptyList();
        }
        List searchHits = search.getSearchHits();
        return searchHits.stream().map(SearchHit::getContent).toList();
    }
}

