/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.kumiho.handler;

import cn.hutool.core.util.ClassUtil;
import com.elitesland.cbpl.kumiho.handler.KumihoHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class KumihoDefaultHandler
extends KumihoHandler {
    private static final Logger logger = LoggerFactory.getLogger(KumihoDefaultHandler.class);

    @Override
    public List<Object> aggregate(Object[] args, Object result) {
        if (result == null) {
            logger.info("[KUMIHO] aggregate data empty.");
            return Collections.emptyList();
        }
        Class<?> clazz = result.getClass();
        if (ClassUtil.isSimpleValueType(clazz)) {
            logger.info("[KUMIHO] aggregate class is basic type.");
            return Collections.emptyList();
        }
        if (result instanceof Collection) {
            logger.trace("[KUMIHO] aggregate class is collection.");
            return (List)result;
        }
        if (ClassUtil.isJdkClass(clazz)) {
            logger.trace("[KUMIHO] aggregate class in JDK.");
            return Collections.emptyList();
        }
        if (ClassUtil.isNormalClass(clazz)) {
            logger.trace("[KUMIHO] aggregate class is normal.");
            return List.of(result);
        }
        logger.info("[KUMIHO] aggregate class is unrecognized.");
        return Collections.emptyList();
    }
}

