/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.kumiho.service;

import com.elitesland.cbpl.elastic.repository.ElasticRepository;
import com.elitesland.cbpl.kumiho.util.KumihoEsUtil;
import com.elitesland.yst.common.base.PagingVO;
import java.io.Serializable;
import java.util.List;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class KumihoEsService {
    private static final Logger logger = LoggerFactory.getLogger(KumihoEsService.class);
    private static final int KUMIHO_ES_PAGE = 0;
    private static final int KUMIHO_ES_SIZE = 20;
    @Autowired
    private ElasticRepository elasticRepository;

    public <T> List<T> queryList(T query) {
        Class<?> clazz = query.getClass();
        String indexName = KumihoEsUtil.indexNameByClz(clazz);
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        NativeSearchQuery nativeSearchQuery = new NativeSearchQueryBuilder().withQuery((QueryBuilder)boolQueryBuilder).build();
        return this.elasticRepository.queryList(indexName, clazz, nativeSearchQuery);
    }

    public <T extends Serializable> PagingVO<T> queryPaging(T query) {
        return this.queryPaging(query, 0, 20);
    }

    private <T extends Serializable> PagingVO<T> queryPaging(T query, int page, int size) {
        Class<?> clazz = query.getClass();
        String indexName = KumihoEsUtil.indexNameByClz(clazz);
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        NativeSearchQuery nativeSearchQuery = ((NativeSearchQueryBuilder)new NativeSearchQueryBuilder().withQuery((QueryBuilder)boolQueryBuilder).withPageable((Pageable)PageRequest.of((int)page, (int)size))).build();
        return this.elasticRepository.queryPaging(indexName, clazz, (Query)nativeSearchQuery);
    }
}

