/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.rosefinch.service.impl;

import com.elitesland.cbpl.rosefinch.entity.RosefinchDetailDO;
import com.elitesland.cbpl.rosefinch.entity.RosefinchLogDO;
import com.elitesland.cbpl.rosefinch.repo.RosefinchDetailRepo;
import com.elitesland.cbpl.rosefinch.repo.RosefinchDetailRepoProc;
import com.elitesland.cbpl.rosefinch.repo.RosefinchRepo;
import com.elitesland.cbpl.rosefinch.repo.RosefinchRepoProc;
import com.elitesland.cbpl.rosefinch.service.RosefinchService;
import com.elitesland.cbpl.rosefinch.udc.LogStatusEnum;
import com.elitesland.cbpl.rosefinch.vo.param.RosefinchDetailPageParamVO;
import com.elitesland.cbpl.rosefinch.vo.param.RosefinchPageParamVO;
import com.elitesland.cbpl.rosefinch.vo.resp.RosefinchDetailRespVO;
import com.elitesland.cbpl.rosefinch.vo.resp.RosefinchListRespVO;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.system.service.SysNumberRuleService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RosefinchServiceImpl
implements RosefinchService {
    private static final Logger logger = LoggerFactory.getLogger(RosefinchServiceImpl.class);
    private final RosefinchRepo rosefinchRepo;
    private final RosefinchRepoProc rosefinchRepoProc;
    private final RosefinchDetailRepo rosefinchDetailRepo;
    private final RosefinchDetailRepoProc rosefinchDetailRepoProc;
    @DubboReference(version="${provider.service.version}")
    private SysNumberRuleService sysNumberRuleService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RosefinchLogDO init(String asyncType, int totalCount) {
        RosefinchLogDO headLog = new RosefinchLogDO();
        String logNo = this.generateCode("ASYNC_TASK", new ArrayList<String>());
        headLog.setLogNo(logNo);
        headLog.setLogStatus(LogStatusEnum.FALSE.getValue());
        headLog.setLogType(asyncType);
        headLog.setSuccessCount(0);
        headLog.setFailCount(0);
        headLog.setTotalCount(totalCount);
        this.rosefinchRepo.save(headLog);
        return headLog;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(RosefinchLogDO headLog, List<RosefinchDetailDO> detailLogList) {
        this.rosefinchRepo.save(headLog);
        detailLogList.forEach(row -> {
            row.setMasId(headLog.getId());
            int idx = Math.min(row.getErrorMsg().length(), 255);
            row.setErrorMsg(row.getErrorMsg().substring(0, idx));
        });
        this.rosefinchDetailRepo.saveAll(detailLogList);
    }

    @Override
    public PagingVO<RosefinchListRespVO> rosefinchPageBy(RosefinchPageParamVO paramVO) {
        long count = this.rosefinchRepoProc.rosefinchCountBy(paramVO);
        if (count > 0L) {
            List<RosefinchListRespVO> list = this.rosefinchRepoProc.rosefinchPageBy(paramVO);
            return new PagingVO(count, list);
        }
        return new PagingVO();
    }

    @Override
    public PagingVO<RosefinchDetailRespVO> rosefinchDetails(RosefinchDetailPageParamVO paramVO) {
        long count = this.rosefinchDetailRepoProc.detailCountBy(paramVO);
        if (count > 0L) {
            List<RosefinchDetailRespVO> list = this.rosefinchDetailRepoProc.detailPageBy(paramVO);
            return new PagingVO(count, list);
        }
        return new PagingVO();
    }

    private String generateCode(String ruleCode, List<String> runtimeValues) {
        try {
            String code = this.sysNumberRuleService.generateCode(ruleCode, runtimeValues);
            if (StringUtils.isEmpty((CharSequence)code)) {
                logger.error("\u8c03\u7528\u53d1\u53f7\u5668\u5f02\u5e38,\u53d1\u53f7\u5668\u7f16\u7801\u672a\u751f\u6210,\u89c4\u5219:" + ruleCode);
                throw new BusinessException(ApiCode.FAIL, "\u8c03\u7528\u53d1\u53f7\u5668\u5f02\u5e38,\u53d1\u53f7\u5668\u7f16\u7801\u672a\u751f\u6210,\u89c4\u5219:" + ruleCode);
            }
            return code;
        }
        catch (Exception e) {
            logger.error("generateCode error:", (Throwable)e);
            throw new BusinessException(ApiCode.FAIL, e.getMessage());
        }
    }

    public RosefinchServiceImpl(RosefinchRepo rosefinchRepo, RosefinchRepoProc rosefinchRepoProc, RosefinchDetailRepo rosefinchDetailRepo, RosefinchDetailRepoProc rosefinchDetailRepoProc, SysNumberRuleService sysNumberRuleService) {
        this.rosefinchRepo = rosefinchRepo;
        this.rosefinchRepoProc = rosefinchRepoProc;
        this.rosefinchDetailRepo = rosefinchDetailRepo;
        this.rosefinchDetailRepoProc = rosefinchDetailRepoProc;
        this.sysNumberRuleService = sysNumberRuleService;
    }
}

