/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.tool.es.service;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.extra.servlet.ServletUtil;
import com.elitesland.cbpl.tool.core.date.DateUtils;
import com.elitesland.cbpl.tool.core.exceptions.ExceptionUtils;
import com.elitesland.cbpl.tool.core.http.HttpServletUtil;
import com.elitesland.cbpl.tool.core.http.RequestWrapper;
import com.elitesland.cbpl.tool.es.domain.TrackDoc;
import com.elitesland.cbpl.tool.es.repository.ElasticsearchRepository;
import com.elitesland.cbpl.tool.es.service.ElasticTrackService;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.skywalking.apm.toolkit.trace.TraceContext;
import org.springframework.stereotype.Service;

@Service
public class ElasticTrackServiceImpl
implements ElasticTrackService {
    @Resource
    private ElasticsearchRepository elasticRepository;

    @Override
    public void info(String indexName, String trackEvent, Object param) {
        this.addSystemLog(indexName, trackEvent, param, "");
    }

    @Override
    public void error(String indexName, String trackEvent, Object param, Exception ex) {
        this.addSystemLog(indexName, trackEvent, param, ExceptionUtils.formatException(ex));
    }

    @Override
    public void error(String indexName, String trackEvent, Object param, String eventError) {
        this.addSystemLog(indexName, trackEvent, param, eventError);
    }

    @Override
    public void trackLog(RequestWrapper request, String indexName, String trackEvent, Object param) {
        this.addSystemLog(request, indexName, trackEvent, param, "");
    }

    private void addSystemLog(String indexName, String trackEvent, Object param, String eventError) {
        HttpServletRequest request = HttpServletUtil.currentRequest();
        RequestWrapper wrapper = ObjectUtil.isNotNull((Object)request) ? new RequestWrapper(request) : null;
        this.addSystemLog(wrapper, indexName, trackEvent, param, eventError);
    }

    private void addSystemLog(RequestWrapper request, String indexName, String trackEvent, Object param, String eventError) {
        TrackDoc trackDoc = new TrackDoc();
        if (ObjectUtil.isNotNull((Object)((Object)request))) {
            trackDoc.setRequestUrl(request.getRequestURL());
            trackDoc.setRequestMethod(request.getMethod());
            trackDoc.setRequestHeader(HttpServletUtil.getHeaders((HttpServletRequest)request));
            trackDoc.setRequestParams(HttpServletUtil.getParameters((HttpServletRequest)request));
            trackDoc.setRequestBody(request.getBodyString());
            trackDoc.setAddressIp(ServletUtil.getClientIP((HttpServletRequest)request, (String[])new String[0]));
        }
        trackDoc.setTraceId(TraceContext.traceId());
        trackDoc.setTrackType(trackEvent);
        trackDoc.setCreateTime(DateUtils.nowStr());
        trackDoc.setEventParam(param);
        trackDoc.setErrorMessage(eventError);
        this.elasticRepository.insert(trackDoc, indexName);
    }
}

