/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.tool.core.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseWrapper
extends HttpServletResponseWrapper {
    private static final Logger logger = LoggerFactory.getLogger(ResponseWrapper.class);
    private final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();

    public ResponseWrapper(HttpServletResponse response) {
        super(response);
    }

    public PrintWriter getWriter() {
        return new PrintWriter(this.outputStream);
    }

    public ServletOutputStream getOutputStream() {
        return new ServletOutputStream(){

            public boolean isReady() {
                return false;
            }

            public void setWriteListener(WriteListener listener) {
            }

            public void write(int b) {
                ResponseWrapper.this.outputStream.write(b);
            }
        };
    }

    public byte[] getResponseData() {
        try {
            this.outputStream.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.outputStream.toByteArray();
    }

    public String getResponseString() {
        return new String(this.getResponseData(), StandardCharsets.UTF_8);
    }
}

