/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.context.flyway;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitesland.cloudt.context.flyway.FlywayCloudtProperties;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.flywaydb.core.Flyway;

public class FlywayBuilder {
    private static final Logger log = LogManager.getLogger(FlywayBuilder.class);
    private final DataSource dataSource;
    private final FlywayCloudtProperties properties;

    public FlywayBuilder(DataSource dataSource, FlywayCloudtProperties properties) {
        this.dataSource = dataSource;
        this.properties = properties;
    }

    Flyway createFlywayForSys() {
        return Flyway.configure().dataSource(this.dataSource).locations(new String[]{(String)Assert.notBlank((CharSequence)this.properties.getLocationSys())}).baselineOnMigrate(true).baselineVersion("1").validateOnMigrate(true).validateMigrationNaming(true).load();
    }

    public Flyway createFlywayForTenant(String prefix, String schema) {
        prefix = CharSequenceUtil.isBlank((CharSequence)prefix) ? "" : (String)prefix + "_";
        return Flyway.configure().dataSource(this.dataSource).locations(new String[]{this.properties.getLocationTenant()}).schemas(new String[]{(String)prefix + schema}).baselineVersion("1").validateOnMigrate(true).validateMigrationNaming(true).load();
    }
}

