/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.context;

import com.elitesland.cloudt.context.SpringContextHolder;
import com.elitesland.cloudt.context.util.DatetimeUtil;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.core.task.TaskExecutor;
import org.springframework.lang.NonNull;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.annotation.EnableAsync;

@AutoConfiguration
@Import(value={JacksonConfiguration.class, AsyncConfiguration.class})
@Order(value=-2147483648)
public class CloudtContextAutoConfiguration
implements ApplicationContextAware {
    private static final Logger log = LogManager.getLogger(CloudtContextAutoConfiguration.class);

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
        this.onApplicationContext(applicationContext);
    }

    private void onApplicationContext(ApplicationContext applicationContext) {
        SpringContextHolder.setApplicationContext(applicationContext);
    }

    @Configuration(proxyBeanMethods=false)
    @EnableAsync
    static class AsyncConfiguration
    implements AsyncConfigurer {
        private static final Logger log = LogManager.getLogger(AsyncConfiguration.class);
        private final TaskExecutor taskExecutor;

        public AsyncConfiguration(TaskExecutor taskExecutor) {
            this.taskExecutor = taskExecutor;
        }

        public Executor getAsyncExecutor() {
            return this.taskExecutor;
        }

        public AsyncUncaughtExceptionHandler getAsyncUncaughtExceptionHandler() {
            return (ex, method, params) -> log.error("\u5f02\u6b65\u7ebf\u7a0b\u3010" + method.getDeclaringClass().getName() + "." + method.getName() + "\u3011\u6267\u884c\u5f02\u5e38\uff1a", ex);
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class JacksonConfiguration {
        JacksonConfiguration() {
        }

        @Bean
        public Jackson2ObjectMapperBuilderCustomizer jackson2ObjectMapperBuilderCustomizer() {
            return jacksonObjectMapperBuilder -> jacksonObjectMapperBuilder.failOnUnknownProperties(false).failOnEmptyBeans(false).serializerByType(Long.class, (JsonSerializer)ToStringSerializer.instance).serializerByType(Long.TYPE, (JsonSerializer)ToStringSerializer.instance).serializerByType(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(DatetimeUtil.FORMATTER_DATETIME)).deserializerByType(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(DatetimeUtil.FORMATTER_DATETIME)).serializerByType(LocalDate.class, (JsonSerializer)new LocalDateSerializer(DatetimeUtil.FORMATTER_DATE)).deserializerByType(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(DatetimeUtil.FORMATTER_DATE));
        }

        @Bean
        public LocalDateTimeSerializer localDateTimeSerializer() {
            return new LocalDateTimeSerializer(DatetimeUtil.FORMATTER_DATETIME);
        }

        @Bean
        public LocalDateTimeDeserializer localDateTimeDeserializer() {
            return new LocalDateTimeDeserializer(DatetimeUtil.FORMATTER_DATETIME);
        }
    }
}

