/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.context.support;

import cn.hutool.core.net.NetUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitesland.cloudt.context.SpringContextHolder;
import java.lang.reflect.Field;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class CloudtApplicationRunListener
implements SpringApplicationRunListener {
    private static final Logger log = LogManager.getLogger(CloudtApplicationRunListener.class);
    private final SpringApplication springApplication;
    private static final AtomicBoolean READY = new AtomicBoolean(false);

    public CloudtApplicationRunListener(SpringApplication springApplication, String[] args) {
        this.springApplication = springApplication;
    }

    public void ready(ConfigurableApplicationContext context, Duration timeTaken) {
        this.logStartedInfo(timeTaken);
    }

    private void logStartedInfo(Duration timeTaken) {
        if (!READY.get() && this.supportLogStartInfo() && READY.compareAndSet(false, true)) {
            log.info("\u7cfb\u7edf\u542f\u52a8\u5b8c\u6210\uff0c\u8017\u65f6\uff1a{}s\uff01", (Object)timeTaken.toSeconds());
            String javaDocUri = this.generateJavaDocUri();
            if (StringUtils.hasText((String)javaDocUri)) {
                log.info("\u53ef\u8bbf\u95eeAPI\uff1a{}", (Object)javaDocUri);
            }
        }
    }

    private String generateJavaDocUri() {
        String uriPrefix = this.obtainUriPrefix();
        String uri = this.javaDocUriForSwagger();
        if (StringUtils.hasText((String)uri)) {
            return uriPrefix + uri;
        }
        uri = this.javaDocUriForSmartDoc();
        if (StringUtils.hasText((String)uri)) {
            return uriPrefix + uri;
        }
        return null;
    }

    private String obtainUriPrefix() {
        String contextPath = this.obtainContextPath();
        String prefix = this.uriPrefixForDubbo();
        if (StringUtils.hasText((String)prefix)) {
            return prefix + contextPath;
        }
        String ip = NetUtil.getLocalhostStr();
        Integer port = SpringContextHolder.getProperty("server.port", Integer.class, 8080);
        return "http://" + ip + ":" + port + contextPath;
    }

    private String obtainContextPath() {
        Object contextPath = SpringContextHolder.getProperty("server.servlet.context-path");
        if (!StringUtils.hasText((String)contextPath)) {
            return "";
        }
        if (!((String)contextPath).startsWith("/")) {
            contextPath = "/" + (String)contextPath;
        }
        if (((String)contextPath).endsWith("/")) {
            contextPath = ((String)contextPath).substring(0, ((String)contextPath).length() - 1);
        }
        return contextPath;
    }

    private String uriPrefixForDubbo() {
        String ip = SpringContextHolder.getProperty("DUBBO_IP_TO_REGISTRY");
        if (!StringUtils.hasText((String)ip)) {
            return null;
        }
        Integer port = SpringContextHolder.getProperty("DUBBO_PORT_TO_REGISTRY", Integer.class, 20880);
        String applicationName = SpringContextHolder.getApplicationName();
        return "http://" + ip + ":" + port + "/" + applicationName;
    }

    private String javaDocUriForSwagger() {
        String uri = "/doc.html";
        boolean enabled = SpringContextHolder.getProperty("knife4j.enable", Boolean.class, false);
        if (enabled) {
            return uri;
        }
        return null;
    }

    private String javaDocUriForSmartDoc() {
        Resource index = SpringContextHolder.getResource("classpath:static/doc/index.html");
        if (index != null && index.exists()) {
            return "/doc/index.html";
        }
        return null;
    }

    private boolean supportLogStartInfo() {
        try {
            String fieldName = "logStartupInfo";
            Field field = ReflectionUtils.findField(SpringApplication.class, (String)fieldName);
            if (field == null) {
                log.error("not found field 'logStartupInfo' in SpringApplication !");
                return false;
            }
            boolean canAccess = field.canAccess(this.springApplication);
            if (!canAccess) {
                field.setAccessible(true);
                boolean result = field.getBoolean(this.springApplication);
                field.setAccessible(false);
                return result;
            }
            return field.getBoolean(this.springApplication);
        }
        catch (IllegalAccessException e) {
            log.error("obtain logStartupInfo fail\uff1a", (Throwable)e);
            return false;
        }
    }

    private int getPort(ServerProperties serverProperties) {
        return Objects.requireNonNullElse(serverProperties.getPort(), 8080);
    }

    private String getContextPath(ServerProperties serverProperties) {
        String contextPath = serverProperties.getServlet().getContextPath();
        if (!StringUtils.hasText((String)contextPath)) {
            return "";
        }
        return "/" + CharSequenceUtil.strip((CharSequence)contextPath, (CharSequence)"/");
    }
}

