/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.context.transaction;

import com.elitesland.cloudt.context.transaction.TransactionProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.aopalliance.aop.Advice;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.aop.Advisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.interceptor.NameMatchTransactionAttributeSource;
import org.springframework.transaction.interceptor.RollbackRuleAttribute;
import org.springframework.transaction.interceptor.RuleBasedTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionInterceptor;

@Aspect
@AutoConfiguration
@ConditionalOnProperty(prefix="elitesland.transaction", name={"enable"}, havingValue="true")
@EnableConfigurationProperties(value={TransactionProperties.class})
@EnableTransactionManagement
public class TransactionAutoConfiguration {
    private final Set<String> defaultRequiredPrefix = Set.of("add", "insert", "create", "submit", "update", "modify", "edit", "save", "delete", "remove", "batch", "set", "exec", "import");
    private final Set<String> defaultReadonlyPrefix = Set.of("get", "find", "query", "list", "page", "select", "count", "is", "exists", "all", "export");
    private final PlatformTransactionManager transactionManager;
    private final TransactionProperties transactionProperties;

    public TransactionAutoConfiguration(PlatformTransactionManager transactionManager, TransactionProperties transactionProperties) {
        this.transactionManager = transactionManager;
        this.transactionProperties = transactionProperties;
    }

    @Bean(value={"txAdvice"})
    public TransactionInterceptor transactionInterceptor() {
        NameMatchTransactionAttributeSource source = new NameMatchTransactionAttributeSource();
        source.setNameMap(this.obtainTransactionAttribute());
        TransactionInterceptor transactionInterceptor = new TransactionInterceptor();
        transactionInterceptor.setTransactionManager((TransactionManager)this.transactionManager);
        transactionInterceptor.setTransactionAttributeSource((TransactionAttributeSource)source);
        return transactionInterceptor;
    }

    @Bean(value={"transactionAdviceAdvisor"})
    public Advisor transactionAdviceAdvisor() {
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        pointcut.setExpression("execution(" + this.transactionProperties.getPointcut() + ")");
        return new DefaultPointcutAdvisor((Pointcut)pointcut, (Advice)this.transactionInterceptor());
    }

    private Map<String, TransactionAttribute> obtainTransactionAttribute() {
        RuleBasedTransactionAttribute readonly = new RuleBasedTransactionAttribute();
        readonly.setReadOnly(true);
        readonly.setPropagationBehavior(5);
        RuleBasedTransactionAttribute required = new RuleBasedTransactionAttribute();
        required.setReadOnly(false);
        required.setPropagationBehavior(0);
        required.setTimeout((int)this.transactionProperties.getTimeout().toSeconds());
        required.getRollbackRules().add(new RollbackRuleAttribute(Exception.class));
        Set<String> setRequired = this.transactionProperties.getRequiredMethodPrefix();
        setRequired.addAll(this.defaultRequiredPrefix);
        setRequired.remove("*");
        Set<String> setReadonly = this.transactionProperties.getReadonlyMethodPrefix();
        setReadonly.addAll(this.defaultReadonlyPrefix);
        setReadonly.remove("*");
        HashMap<String, TransactionAttribute> attributeMap = new HashMap<String, TransactionAttribute>(64);
        for (String p : setRequired) {
            attributeMap.put(p.trim() + "*", (TransactionAttribute)required);
        }
        for (String p : setReadonly) {
            attributeMap.put(p.trim() + "*", (TransactionAttribute)readonly);
        }
        attributeMap.put("*", (TransactionAttribute)readonly);
        return attributeMap;
    }
}

