/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.context.util;

import com.elitesland.cloudt.context.util.ValidateUtil;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.StringUtils;

public class HttpServletUtil {
    public static final String PROTOCOL_HTTPS = "https://";
    public static final String PROTOCOL_HTTP = "http://";

    private HttpServletUtil() {
    }

    public static String obtainDomain(HttpServletRequest request) {
        String ip = HttpServletUtil.obtainDomain(request.getRequestURL().toString());
        if (!ValidateUtil.isIp(ip)) {
            return ip;
        }
        String domain = request.getHeader("Host");
        if (StringUtils.hasText((String)domain) && !ValidateUtil.isIp(domain.split(":")[0])) {
            return domain;
        }
        domain = request.getHeader("Referer");
        if (StringUtils.hasText((String)domain) && !ValidateUtil.isIp(domain = HttpServletUtil.obtainDomain(domain))) {
            return domain;
        }
        domain = request.getHeader("Origin");
        if (StringUtils.hasText((String)domain) && !ValidateUtil.isIp(domain = HttpServletUtil.obtainDomain(domain))) {
            return domain;
        }
        return ip;
    }

    public static String obtainDomain(String url) {
        boolean isHttpProtocol = false;
        if (url.startsWith(PROTOCOL_HTTP)) {
            url = url.substring(7);
            isHttpProtocol = true;
        } else if (url.startsWith(PROTOCOL_HTTPS)) {
            url = url.substring(8);
            isHttpProtocol = true;
        }
        if (!isHttpProtocol) {
            return null;
        }
        int lastIndex = url.indexOf("/");
        if (lastIndex > 0) {
            url = url.substring(0, lastIndex);
        }
        if ((lastIndex = url.indexOf(":")) > 0) {
            url = url.substring(0, lastIndex);
        }
        return url;
    }
}

