/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.context.redis.redisson;

import com.elitesland.cloudt.context.redis.CloudtRedisProperties;
import com.elitesland.cloudt.context.redis.redisson.RedissonCustomProperties;
import java.lang.invoke.CallSite;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;
import org.redisson.spring.cache.CacheConfig;
import org.redisson.spring.cache.RedissonSpringCacheManager;
import org.redisson.spring.data.connection.RedissonConnectionFactory;
import org.redisson.spring.starter.RedissonAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.connection.RedisConnectionFactory;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={RedissonCustomProperties.class, RedisProperties.class})
@ConditionalOnClass(value={Redisson.class})
@ConditionalOnProperty(prefix="elitesland.redis.redisson", name={"enabled"}, havingValue="true", matchIfMissing=true)
@AutoConfigureBefore(value={RedissonAutoConfiguration.class})
public class RedissonCustomAutoConfiguration {
    private static final Logger log = LogManager.getLogger(RedissonCustomAutoConfiguration.class);
    private static final String REDIS_PROTOCOL_PREFIX = "redis://";
    private static final String REDISS_PROTOCOL_PREFIX = "rediss://";
    private final RedissonCustomProperties redissonCustomProperties;
    private final RedisProperties redisProperties;

    public RedissonCustomAutoConfiguration(RedissonCustomProperties redissonCustomProperties, RedisProperties redisProperties) {
        this.redissonCustomProperties = redissonCustomProperties;
        this.redisProperties = redisProperties;
        log.info("\u521d\u59cb\u5316\u65b0\u7684redisson\u914d\u7f6e");
    }

    @Bean(destroyMethod="shutdown")
    @Primary
    public RedissonClient redissonClient() {
        Config config = this.redissonCustomProperties.buildConfig();
        if (config == null) {
            config = this.buildRedissonConfigByRedis();
        }
        return Redisson.create((Config)config);
    }

    @Bean
    public RedisConnectionFactory redisConnectionFactory(RedissonClient redissonClient) {
        return new RedissonConnectionFactory(redissonClient);
    }

    @Bean
    public CacheManager redissonManager(RedissonClient redissonClient, CloudtRedisProperties cloudtRedisProperties) {
        HashMap<CallSite, CacheConfig> configHashedMap = new HashMap<CallSite, CacheConfig>();
        configHashedMap.put((CallSite)((Object)(cloudtRedisProperties.getPrefix() + ":longCache")), new CacheConfig(180000L, 120000L));
        configHashedMap.put((CallSite)((Object)(cloudtRedisProperties.getPrefix() + ":shortCache")), new CacheConfig(60000L, 30000L));
        return new RedissonSpringCacheManager(redissonClient, configHashedMap);
    }

    private Config buildRedissonConfigByRedis() {
        int timeout = (int)this.obtainTimeout();
        Config config = null;
        if (this.redisProperties.getSentinel() != null) {
            String[] nodes = this.convert(this.redisProperties.getSentinel().getNodes());
            config = new Config();
            ((SentinelServersConfig)config.useSentinelServers().setMasterName(this.redisProperties.getSentinel().getMaster()).addSentinelAddress(nodes).setDatabase(this.redisProperties.getDatabase()).setConnectTimeout(timeout)).setPassword(this.redisProperties.getPassword());
        } else if (this.redisProperties.getCluster() != null) {
            String[] nodes = this.convert(this.redisProperties.getCluster().getNodes());
            config = new Config();
            ((ClusterServersConfig)config.useClusterServers().addNodeAddress(nodes).setConnectTimeout(timeout)).setPassword(this.redisProperties.getPassword());
        } else {
            config = new Config();
            String prefix = REDIS_PROTOCOL_PREFIX;
            if (this.redisProperties.isSsl()) {
                prefix = REDISS_PROTOCOL_PREFIX;
            }
            ((SingleServerConfig)config.useSingleServer().setAddress(prefix + this.redisProperties.getHost() + ":" + this.redisProperties.getPort()).setConnectTimeout(timeout)).setDatabase(this.redisProperties.getDatabase()).setPassword(this.redisProperties.getPassword());
        }
        return config;
    }

    private long obtainTimeout() {
        Duration timeoutValue = this.redisProperties.getTimeout();
        return timeoutValue == null ? 10000L : timeoutValue.toMillis();
    }

    private String[] convert(List<String> nodesObject) {
        ArrayList<Object> nodes = new ArrayList<Object>(nodesObject.size());
        for (String node : nodesObject) {
            if (!node.startsWith(REDIS_PROTOCOL_PREFIX) && !node.startsWith(REDISS_PROTOCOL_PREFIX)) {
                nodes.add(REDIS_PROTOCOL_PREFIX + node);
                continue;
            }
            nodes.add(node);
        }
        return nodes.toArray(new String[0]);
    }
}

