/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.tool.version.service;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.tool.version.annotation.PhoenixVersion;
import com.elitesland.cbpl.tool.version.domain.VersionVO;
import com.elitesland.cbpl.tool.version.util.ManifestUtils;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class VersionProvider {
    private static final Logger logger = LoggerFactory.getLogger(VersionProvider.class);
    @Resource
    private Reflections reflections;

    public List<VersionVO> dependencies() {
        if (ObjectUtil.isEmpty((Object)this.reflections)) {
            logger.debug("[PHOENIX-VERSION] Reflections Not Declaring.");
            return ListUtil.empty();
        }
        Set typesAnnotatedWith = this.reflections.getTypesAnnotatedWith(PhoenixVersion.class);
        return typesAnnotatedWith.stream().map(clazz -> {
            PhoenixVersion version = clazz.getAnnotation(PhoenixVersion.class);
            return ManifestUtils.dependency(clazz, version.description());
        }).collect(Collectors.toList());
    }
}

