package com.elitesland.cbpl.tool.version.service;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.tool.version.domain.VersionVO;
import com.elitesland.cbpl.tool.version.util.PhoenixVersionUtil;
import lombok.extern.slf4j.Slf4j;
import org.reflections.Reflections;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author eric.hao
 * @since 2024/02/21
 */
@Slf4j
@Component
public class VersionProvider {

    @Resource
    private Reflections reflections;

    /**
     * 获取所有 Phoenix 工具集的版本
     *
     * @return 版本信息
     */
    public List<VersionVO> dependencies() {
        if (ObjectUtil.isEmpty(reflections)) {
            logger.debug("[PHOENIX-VERSION] Reflections Not Declaring.");
            return ListUtil.empty();
        }
        return PhoenixVersionUtil.dependencies(reflections);
    }
}
