package com.elitesland.cbpl.tool.version.util;

import cn.hutool.core.io.ManifestUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.tool.version.annotation.PhoenixVersion;
import com.elitesland.cbpl.tool.version.domain.VersionVO;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;

import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

import static com.elitesland.cbpl.tool.version.constant.ManifestAttr.*;

/**
 * @author eric.hao
 * @since 2024/02/20
 */
@Slf4j
public class ManifestUtils {

    /**
     * 根据 class 获取 所在 jar 包版本信息
     *
     * @param clazz         类
     * @param gitProperties 所有git配置
     * @return 版本信息
     */
    @SneakyThrows
    public static VersionVO dependency(Class<?> clazz, Map<String, Properties> gitProperties) {
        Attributes attributes = getMainAttributes(clazz);
        VersionVO.VersionVOBuilder builder = VersionVO.builder();
        // 基础信息
        PhoenixVersion version = clazz.getAnnotation(PhoenixVersion.class);
        builder.className(clazz.getName());
        builder.moduleCode(version.code());
        builder.moduleName(version.description());

        // 构建信息
        String moduleName = "";
        if (attributes != null && !attributes.isEmpty()) {
            moduleName = attributes.getValue(MAVEN_MODULE);
            builder.mavenGroup(attributes.getValue(MAVEN_GROUP));
            builder.mavenModule(moduleName);
            builder.jdkSpec(attributes.getValue(BUILD_JDK_SPEC));
            builder.buildTime(attributes.getValue(BUILD_TIME));
            builder.gradlePluginVersion(attributes.getValue(GRADLE_PLUGIN_VERSION));
            builder.supportDepsVersion(attributes.getValue(SUPPORT_DEPS_VERSION));
            builder.toolDepsVersion(attributes.getValue(TOOL_DEPS_VERSION));
            builder.phoenixVersion(attributes.getValue(PHOENIX_DEPS_VERSION));
        }
        // 其他信息
        Properties properties = gitProperties.get(moduleName);
        if (ObjectUtil.isNotEmpty(properties)) {
            builder.repositoryUrl(properties.getProperty("git.remote.origin.url"));
            builder.repositoryBranch(properties.getProperty("git.branch"));
            builder.commitId(properties.getProperty("git.commit.id"));
            builder.mavenVersion(properties.getProperty("git.build.version"));
        }
        return builder.build();
    }

    /**
     * 根据 class 获取 所在 jar 包文件的 Manifest 属性值
     *
     * @param clazz 类
     * @return Manifest
     */
    private static Attributes getMainAttributes(Class<?> clazz) {
        Manifest manifest = ManifestUtil.getManifest(clazz);
        return ObjectUtil.isEmpty(manifest) ? null : manifest.getMainAttributes();
    }
}
