package com.elitesland.cbpl.common.constant;

import cn.hutool.core.util.ObjectUtil;
import lombok.Getter;

/**
 * @author eric.hao
 * @version 0.1.12-SNAPSHOT
 * @since 2024/05/16
 */
@Getter
public enum DeprecatedStatus {

    /**
     * 废弃标识
     */
    NOT_DEPRECATED(0, "未废弃"),
    DEPRECATED(1, "已废弃"),
    ;

    private final Integer code;
    private final String desc;

    DeprecatedStatus(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static String fromCode(Integer code) {
        if (ObjectUtil.isNull(code)) return null;
        for (DeprecatedStatus status : DeprecatedStatus.values()) {
            if (status.getCode().compareTo(code) == 0) {
                return status.getDesc();
            }
        }
        return "";
    }
}
