package com.elitesland.cbpl.common.constant;

import cn.hutool.core.util.ObjectUtil;
import lombok.Getter;

/**
 * @author eric.hao
 * @version 0.1.12-SNAPSHOT
 * @since 2024/05/16
 */
@Getter
public enum PublishStatus {

    /**
     * 版本发布状态
     */
    UN_PUBLISHED(1, "未发布"),
    PUBLISHED(2, "发布成功"),
    EFFECTIVE(3, "生效中"),
    ;

    private final Integer code;
    private final String desc;

    PublishStatus(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static String fromCode(Integer code) {
        if (ObjectUtil.isNull(code)) return null;
        for (PublishStatus status : PublishStatus.values()) {
            if (status.getCode().compareTo(code) == 0) {
                return status.getDesc();
            }
        }
        return "";
    }
}
