package com.elitesland.cbpl.tool.core.bean;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

import java.time.LocalDate;
import java.time.LocalDateTime;

import static cn.hutool.core.date.DatePattern.*;

/**
 * 参考云梯，增强对日期字段做格式化
 *
 * @author eric.hao
 * @version 0.1.15-SNAPSHOT
 * @since 2024/08/06
 */
public class ObjectMapperFactory {

    private static ObjectMapper INSTANCE = null;

    /**
     * ObjectMapper实例
     *
     * @return objectMapper
     */
    public static ObjectMapper instance() {
        if (INSTANCE == null) {
            synchronized (ObjectMapperFactory.class) {
                if (INSTANCE != null) {
                    return INSTANCE;
                }
                INSTANCE = builderInstance()
                        .build();
            }
        }
        return INSTANCE;
    }

    /**
     * 构建者实例
     *
     * @return 构建者实例
     */
    public static Jackson2ObjectMapperBuilder builderInstance() {
        return ObjectMapperFactory.builderInstance(Jackson2ObjectMapperBuilder.json());
    }

    /**
     * 构建者实例
     *
     * @param builder 已有实例
     * @return 构建者实例
     */
    public static Jackson2ObjectMapperBuilder builderInstance(Jackson2ObjectMapperBuilder builder) {
        return builder
                .serializerByType(LocalDateTime.class, new LocalDateTimeSerializer(NORM_DATETIME_FORMATTER))
                .serializerByType(LocalDate.class, new LocalDateSerializer(NORM_DATE_FORMATTER))
                .deserializerByType(LocalDateTime.class, new LocalDateTimeDeserializer(NORM_DATETIME_FORMATTER))
                .deserializerByType(LocalDate.class, new LocalDateDeserializer(NORM_DATE_FORMATTER))
                .simpleDateFormat(NORM_DATETIME_PATTERN)
                .serializerByType(Long.class, ToStringSerializer.instance)
                .serializerByType(Long.TYPE, ToStringSerializer.instance)
                .failOnUnknownProperties(false)
                .failOnEmptyBeans(false);
    }
}
