package com.elitesland.cbpl.tool.cron;

import cn.hutool.core.date.DateUtil;
import cn.hutool.cron.pattern.CronPatternUtil;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author eric.hao
 * @since 2024/05/13
 */
public class CronPatternUtils {

    /**
     * CRON 表达式预览
     *
     * @param patternStr CRON表达式
     * @param count      预览后续执行次数
     * @return 执行时间
     * @since 0.1.11-SNAPSHOT
     */
    public static List<String> preview(String patternStr, int count) {
        List<Date> dates = CronPatternUtil.matchedDates(patternStr, new Date(), count, true);
        return dates.stream().map(DateUtil::formatDateTime).collect(Collectors.toList());
    }
}
