package com.elitesland.cbpl.tool.extra.git;

import com.elitesland.cbpl.tool.core.io.PropertiesUtil;
import com.elitesland.cbpl.tool.extra.git.constant.GitCommitAttr;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;

import static com.elitesland.cbpl.tool.extra.git.constant.GitCommitAttr.GIT_COMMIT_MODULE;

/**
 * @author eric.hao
 * @since 2024/02/29
 */
public class GitUtil {

    /**
     * 读取所有jar包的git信息
     *
     * @return git.properties
     */
    public static Map<String, Properties> loadProperties() {
        List<Properties> properties = PropertiesUtil.loadProperties(GitCommitAttr.GIT_PROPERTIES);
        return properties.stream().collect(Collectors.toMap(row ->
                (String) row.get(GIT_COMMIT_MODULE), Function.identity()));
    }
}
