package com.elitesland.cbpl.tool.mongo.config;

import com.elitesland.cbpl.tool.mongo.repository.MongoStorer;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.core.MongoTemplate;

/**
 * MongoDB持久服务
 *
 * @author eric.hao
 * @since 2022/09/15
 */
@Slf4j
@Configuration
@ConditionalOnProperty(prefix = "spring.data.mongodb", name = "auto-index-creation", havingValue = "true")
public class MongoAutoConfiguration {

    @Bean
    @ConditionalOnMissingBean
    MongoStorer mongoStorer(MongoTemplate mongoTemplate) {
        logger.info("[MONGO] mongoStorer");
        return new MongoStorer(mongoTemplate);
    }
}
