package com.elitesland.cbpl.tool.mongo.domain;

import java.io.Serializable;
import java.time.temporal.TemporalAccessor;

/**
 * 存储对象
 *
 * @author eric.hao
 * @since 2022/09/14
 */
public interface MongoDoc extends Serializable {

    /**
     * @return 消息ID
     */
    String getId();

    /**
     * @return 消息类型
     */
    <T extends StoreDef> T getType();

    /**
     * @return 产生时间
     */
    TemporalAccessor getTime();

    /**
     * @return 扩展信息
     */
    Object getExtInfo();
}
