/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.common.constant;

import cn.hutool.core.util.ObjectUtil;

public enum StorageStrategy {
    DATA_SS_CONSOLE("Console", "\u672c\u5730\u63a7\u5236\u53f0"),
    DATA_SS_MYSQL("MySQL", "MySQL\u6570\u636e\u5e93"),
    DATA_SS_ORACLE("Oracle", "Oracle\u6570\u636e\u5e93"),
    DATA_SS_MONGO("MongoDB", "MongoDB\u6570\u636e\u5e93"),
    DATA_SS_ES("ES", "Elasticsearch"),
    DATA_SS_REDIS("Redis", "Redis");

    private final String code;
    private final String desc;

    private StorageStrategy(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static String fromCode(String code) {
        if (ObjectUtil.isNull((Object)code)) {
            return null;
        }
        for (StorageStrategy status : StorageStrategy.values()) {
            if (status.getCode().compareTo(code) != 0) continue;
            return status.getDesc();
        }
        return "";
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }
}

