/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.tool.websocket.registrar;

import com.corundumstudio.socketio.SocketIOServer;
import com.elitesland.cbpl.tool.websocket.handler.WebSocketSessionManager;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketListener {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketListener.class);
    private final SocketIOServer socketIoServer;

    @PostConstruct
    public void init() {
        logger.debug("SocketEventListener initialized");
        this.socketIoServer.addConnectListener(session -> {
            String userId = WebSocketSessionManager.getUserId(session);
            logger.info("[PHOENIX-WS] websocket connection established: {} of u-{}", (Object)session.getSessionId(), (Object)userId);
            WebSocketSessionManager.add(session);
        });
        this.socketIoServer.addDisconnectListener(client -> {
            String userId = WebSocketSessionManager.getUserId(client);
            logger.info("[PHOENIX-WS] websocket disconnection finished: {} of u-{}", (Object)client.getSessionId(), (Object)userId);
            WebSocketSessionManager.removeAndClose(client);
        });
    }

    @PreDestroy
    private void destroy() {
        try {
            logger.info("[PHOENIX-WS] websocket server closed.");
            this.socketIoServer.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public WebSocketListener(SocketIOServer socketIoServer) {
        this.socketIoServer = socketIoServer;
    }
}

