/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.tool.core.http;

import cn.hutool.core.net.url.UrlBuilder;
import cn.hutool.core.net.url.UrlQuery;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.extra.servlet.ServletUtil;
import com.elitesland.cbpl.tool.core.http.RequestWrapper;
import com.elitesland.cbpl.tool.core.http.ResponseWrapper;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class HttpServletUtil {
    public static String currentClientIp() {
        HttpServletRequest request = HttpServletUtil.currentRequest();
        if (request == null) {
            return null;
        }
        return ServletUtil.getClientIP((HttpServletRequest)request, (String[])new String[0]);
    }

    public static HttpServletRequest currentRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            return null;
        }
        return ((ServletRequestAttributes)requestAttributes).getRequest();
    }

    public static RequestWrapper currentRequestWrapper() {
        HttpServletRequest request = HttpServletUtil.currentRequest();
        return ObjectUtil.isNotNull((Object)request) ? new RequestWrapper(request) : null;
    }

    public static MultiValueMap<String, String> getParameters(HttpServletRequest request) {
        Map parameterMap = request.getParameterMap();
        LinkedMultiValueMap parameters = new LinkedMultiValueMap(parameterMap.size());
        parameterMap.forEach((arg_0, arg_1) -> HttpServletUtil.lambda$getParameters$0((MultiValueMap)parameters, arg_0, arg_1));
        return parameters;
    }

    public static MultiValueMap<String, String> getQueryParameters(HttpServletRequest request) {
        String queryString = request.getQueryString();
        if (!StringUtils.hasText((String)queryString)) {
            return new LinkedMultiValueMap(0);
        }
        String[] parameterArray = queryString.split("&");
        LinkedMultiValueMap parameters = new LinkedMultiValueMap(parameterArray.length);
        for (String s : parameterArray) {
            if (!StringUtils.hasText((String)s)) continue;
            String[] params = s.split("=");
            parameters.add((Object)params[0], params.length == 2 ? params[1] : null);
        }
        return parameters;
    }

    public static UrlQuery getQueryParameters(URI uri) {
        UrlBuilder builder = UrlBuilder.of((URI)uri, (Charset)CharsetUtil.CHARSET_UTF_8);
        return builder.getQuery();
    }

    public static UrlQuery getQueryParameters(String httpUrl) {
        UrlBuilder builder = UrlBuilder.ofHttp((String)httpUrl, (Charset)CharsetUtil.CHARSET_UTF_8);
        return builder.getQuery();
    }

    public static MultiValueMap<String, String> getFormParameters(HttpServletRequest request) {
        MultiValueMap<String, String> queryParams = HttpServletUtil.getQueryParameters(request);
        if (queryParams.isEmpty()) {
            return HttpServletUtil.getParameters(request);
        }
        Map parameterMap = request.getParameterMap();
        LinkedMultiValueMap parameters = new LinkedMultiValueMap(parameterMap.size());
        parameterMap.forEach((arg_0, arg_1) -> HttpServletUtil.lambda$getFormParameters$1(queryParams, (MultiValueMap)parameters, arg_0, arg_1));
        return parameters;
    }

    public static MultiValueMap<String, String> getHeaders(HttpServletRequest request) {
        LinkedMultiValueMap headerMap = new LinkedMultiValueMap(64);
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Enumeration values = request.getHeaders(name);
            while (values.hasMoreElements()) {
                headerMap.add((Object)name, (Object)((String)values.nextElement()));
            }
        }
        return headerMap;
    }

    public static RequestWrapper wrapper(ServerHttpRequest request) {
        ServletServerHttpRequest serverHttpRequest = (ServletServerHttpRequest)request;
        return new RequestWrapper(serverHttpRequest.getServletRequest());
    }

    public static ResponseWrapper wrapper(ServerHttpResponse response) {
        ServletServerHttpResponse serverHttpResponse = (ServletServerHttpResponse)response;
        return new ResponseWrapper(serverHttpResponse.getServletResponse());
    }

    private static /* synthetic */ void lambda$getFormParameters$1(MultiValueMap queryParams, MultiValueMap parameters, String key, String[] values) {
        if (queryParams.containsKey((Object)key)) {
            return;
        }
        if (values.length > 0) {
            for (String value : values) {
                parameters.add((Object)key, (Object)value);
            }
        } else {
            parameters.add((Object)key, null);
        }
    }

    private static /* synthetic */ void lambda$getParameters$0(MultiValueMap parameters, String key, String[] values) {
        if (values.length > 0) {
            for (String value : values) {
                parameters.add((Object)key, (Object)value);
            }
        } else {
            parameters.add((Object)key, null);
        }
    }
}

