/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.tool.core.util;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitesland.cbpl.tool.core.exceptions.PhoenixException;
import com.elitesland.cbpl.tool.extra.spring.SpringUtils;
import java.time.Duration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class LockUtil {
    private static final Logger logger = LoggerFactory.getLogger(LockUtil.class);
    private static final ConcurrentHashMap<String, Lock> LOCAL_LOCK = new ConcurrentHashMap(512);
    private static RedissonClient redissonClient;

    private LockUtil() {
    }

    public static <T> T executeByLock(@NotBlank String lockKey, @NotNull Supplier<T> supplier) {
        return LockUtil.executeByLock(lockKey, supplier, null);
    }

    public static <T> T executeByLock(@NotBlank String lockKey, @NotNull Supplier<T> supplier, Duration duration) {
        return LockUtil.executeByLock(lockKey, supplier, duration, null);
    }

    public static <T> void schedulerByLock(@NotBlank String taskCode, @NotNull Runnable executor) {
        Assert.hasText((String)taskCode, (String)"\u9501\u7684\u6807\u8bc6\u4e3a\u7a7a");
        Lock lockLocal = LOCAL_LOCK.computeIfAbsent(taskCode, c -> new ReentrantLock());
        RLock lockRemote = null;
        try {
            logger.info("\u5c1d\u8bd5\u83b7\u53d6\u672c\u5730\u9501\uff1a{}", (Object)taskCode);
            if (lockLocal.tryLock()) {
                lockRemote = LockUtil.getRedissonClient().getLock(taskCode);
                logger.info("\u5c1d\u8bd5\u83b7\u53d6\u8fdc\u7a0b\u9501\uff1a{}", (Object)taskCode);
                if (lockRemote.tryLock()) {
                    executor.run();
                } else {
                    logger.warn("\u8fdc\u7a0b\u9501\u83b7\u53d6\u5931\u8d25-{}\uff1a\u5df2\u6709\u4efb\u52a1\u6b63\u5728\u8fdb\u884c\u4e2d", (Object)taskCode);
                }
            } else {
                logger.warn("\u672c\u5730\u9501\u83b7\u53d6\u5931\u8d25-{}\uff1a\u5df2\u6709\u4efb\u52a1\u6b63\u5728\u8fdb\u884c\u4e2d", (Object)taskCode);
            }
        }
        catch (Throwable e) {
            logger.error("\u52a0\u9501\u7684\u65b9\u6cd5\u4e2d\u51fa\u73b0\u5f02\u5e38\uff1a{}", (Object)taskCode, (Object)e);
            throw new RuntimeException(e);
        }
        finally {
            logger.info("\u91ca\u653e\u672c\u5730\u9501\uff1a{}", (Object)taskCode);
            try {
                lockLocal.unlock();
            }
            catch (Exception e) {
                logger.error("\u672c\u5730\u9501\u91ca\u653e\u5f02\u5e38\uff1a{}", (Object)taskCode, (Object)e);
            }
            if (lockRemote != null && lockRemote.isHeldByCurrentThread() && lockRemote.isLocked()) {
                logger.info("\u91ca\u653e\u8fdc\u7a0b\u9501\uff1a{}", (Object)taskCode);
                try {
                    lockRemote.unlock();
                }
                catch (Exception e) {
                    logger.error("\u8fdc\u7a0b\u9501\u91ca\u653e\u5f02\u5e38\uff1a{}", (Object)taskCode, (Object)e);
                }
            }
        }
    }

    @Deprecated(since="0.1.17-SNAPSHOT", forRemoval=true)
    public static <T> T schedulerByLock(@NotBlank String taskCode, @NotNull Supplier<T> supplier, Duration duration) {
        LockUtil.schedulerByLock(taskCode, supplier::get);
        return null;
    }

    @Deprecated(since="0.1.17-SNAPSHOT", forRemoval=true)
    public static void schedulerByLock(@NotBlank String taskCode, @NotNull Runnable executor, long duration, TimeUnit time) {
        LockUtil.schedulerByLock(taskCode, executor);
    }

    public static <T> T executeByLock(@NotBlank String lockKey, @NotNull Supplier<T> supplier, Duration duration, String acquireFailMsg) {
        Assert.hasText((String)lockKey, (String)"\u9501\u7684\u6807\u8bc6\u4e3a\u7a7a");
        if (duration == null) {
            duration = Duration.ofMinutes(10L);
        }
        Lock lockLocal = LOCAL_LOCK.computeIfAbsent(lockKey, c -> new ReentrantLock());
        RLock lockRemote = null;
        try {
            logger.info("\u5c1d\u8bd5\u83b7\u53d6\u672c\u5730\u9501\uff1a{}\uff0c{}", (Object)lockKey, (Object)duration);
            if (lockLocal.tryLock(duration.getSeconds(), TimeUnit.SECONDS)) {
                lockRemote = LockUtil.getRedissonClient().getLock(lockKey);
                logger.info("\u5c1d\u8bd5\u83b7\u53d6\u8fdc\u7a0b\u9501\uff1a{}\uff0c{}", (Object)lockKey, (Object)duration);
                if (lockRemote.tryLock(duration.getSeconds(), TimeUnit.SECONDS)) {
                    T t = supplier.get();
                    return t;
                }
            }
            try {
                throw PhoenixException.unexpected(CharSequenceUtil.blankToDefault((CharSequence)acquireFailMsg, (String)("\u672a\u83b7\u53d6\u5230\u9501" + lockKey + "\uff0c\u7b49\u5f85\u8d85\u65f6")));
            }
            catch (Throwable e) {
                logger.error("\u52a0\u9501\u7684\u65b9\u6cd5\u4e2d\u51fa\u73b0\u5f02\u5e38\uff1a{}", (Object)lockKey, (Object)e);
                if (e instanceof RuntimeException) {
                    throw (PhoenixException)e;
                }
                throw new RuntimeException(e);
            }
        }
        finally {
            logger.info("\u91ca\u653e\u672c\u5730\u9501\uff1a{}", (Object)lockKey);
            try {
                lockLocal.unlock();
            }
            catch (Exception e) {
                logger.error("\u672c\u5730\u9501\u91ca\u653e\u5f02\u5e38\uff1a{}", (Object)lockKey, (Object)e);
            }
            if (lockRemote != null && lockRemote.isLocked()) {
                logger.info("\u91ca\u653e\u8fdc\u7a0b\u9501\uff1a{}", (Object)lockKey);
                try {
                    lockRemote.unlock();
                }
                catch (Exception e) {
                    logger.error("\u8fdc\u7a0b\u9501\u91ca\u653e\u5f02\u5e38\uff1a{}", (Object)lockKey, (Object)e);
                }
            }
        }
    }

    private static RedissonClient getRedissonClient() {
        if (redissonClient == null) {
            redissonClient = (RedissonClient)SpringUtils.getBean(RedissonClient.class);
        }
        return redissonClient;
    }
}

