/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.tool.websocket.handler;

import com.corundumstudio.socketio.AckRequest;
import com.corundumstudio.socketio.SocketIOClient;
import com.corundumstudio.socketio.annotation.OnEvent;
import com.elitesland.cbpl.tool.extra.spring.SpringUtils;
import com.elitesland.cbpl.tool.websocket.handler.WebSocketSessionManager;
import com.elitesland.cbpl.tool.websocket.notifier.WebSocketNotifier;
import com.elitesland.cbpl.tool.websocket.notifier.domain.ChatPayload;
import com.elitesland.cbpl.tool.websocket.util.WebSocketUtil;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketDefaultHandler {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketDefaultHandler.class);

    @OnEvent(value="message")
    public void onTextMessage(SocketIOClient session, String data, AckRequest ackRequest) {
        logger.info("[PHOENIX-WS] message from websocket client: {}", (Object)data);
        if (ackRequest.isAckRequested()) {
            ackRequest.sendAckData(new Object[]{"success"});
        }
    }

    @OnEvent(value="channel_system")
    public void onChannelSystem(SocketIOClient session, String data, AckRequest ackRequest) {
        String ackData = "success";
        String fromUserId = WebSocketSessionManager.getUserId(session);
        String toUserId = WebSocketUtil.getUrlParams(session, "toUserId");
        logger.info("[PHOENIX-WS] chat message, from-{}, to-{}, message-{}", new Object[]{fromUserId, toUserId, data});
        if (toUserId == null) {
            ackData = "no recipient.";
        } else if (data == null) {
            ackData = "empty message.";
        } else {
            WebSocketNotifier notifier = (WebSocketNotifier)SpringUtils.getBean(WebSocketNotifier.class);
            ChatPayload payload = ChatPayload.builder().content(data).from(fromUserId).tos(Set.of(toUserId)).build();
            notifier.notify(payload);
        }
        if (ackRequest.isAckRequested()) {
            ackRequest.sendAckData(new Object[]{ackData});
        }
    }
}

