/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.tool.websocket.util;

import cn.hutool.core.collection.CollUtil;
import com.corundumstudio.socketio.SocketIOClient;
import io.netty.handler.codec.http.HttpHeaders;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketUtil {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketUtil.class);

    public static String getHeader(SocketIOClient session, String key) {
        try {
            HttpHeaders headers = session.getHandshakeData().getHttpHeaders();
            return headers.get(key);
        }
        catch (Exception e) {
            logger.error("[PHOENIX-WS] get http header({}) error.", (Object)key, (Object)e);
            return null;
        }
    }

    public static String getUrlParams(SocketIOClient session, String key) {
        Map urlParams = session.getHandshakeData().getUrlParams();
        List params = (List)urlParams.get(key);
        if (CollUtil.isNotEmpty((Collection)params)) {
            return (String)params.get(0);
        }
        return null;
    }

    public static String getVisitorId(SocketIOClient session) {
        return WebSocketUtil.getHeader(session, "visitorId");
    }
}

