package com.elitesland.cbpl.srm.supp.dto;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;

/**
 * @Author: meng
 * @since 2022/9/8
 */
@Data
@Api("供应商用户查询")
public class SrmUserRelateRpcDTO implements Serializable {

    @Serial
    private static final long serialVersionUID = 8175919208417534759L;
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("账号唯一ID")
    private Long id;

    @ApiModelProperty("用户ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long sysUserId;

    @ApiModelProperty("用户名")
    private String username;


    @ApiModelProperty("供应商id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppId;

    @ApiModelProperty("供应商编码")
    private String suppCode;

    @ApiModelProperty("供应商名称")
    private String suppName;

    @ApiModelProperty("是否启用1:启用0:禁用")
    private Integer enabled;

    @ApiModelProperty("供应商类型2 [UDC]PUR:SUPP_TYPE2")
    private String suppType;
}
