package com.elitesland.cbpl.srm.supp.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * <p>
 * 功能说明: 供应商基础信息出参对象
 * </p>
 *
 * @Author Darren
 * @Date 2021/02/25
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(value = "purSuppBaseRespVO", description = "供应商基础信息出参对象")
public class PurSuppBaseDTO implements Serializable {
    private static final long serialVersionUID = -6476571338837547527L;

    @ApiModelProperty("供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("供应商编码")
    private String suppCode;

    @ApiModelProperty("供应商名称")
    private String suppName;

    @ApiModelProperty("地址号")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long addrNo;

    @ApiModelProperty("ERP供应商编码")
    private String erpSuppCode;

    @ApiModelProperty("供应商类型2 [UDC]yst-srm:SUPP_TYPE2")
    @SysCode(sys = "yst-srm", mod = "SUPP_TYPE2")
    private String suppType2;
    private String suppType2Name;

    @ApiModelProperty("供应商状态 [UDC]yst-srm:SUPP_STATUS")
    @SysCode(sys = "yst-srm", mod = "SUPP_STATUS")
    private String suppStatus;
    private String suppStatusName;

    @ApiModelProperty("付款条款")
    private String paymentTerm;
    private String paymentTermName;
    @ApiModelProperty("付款方式 [UDC]yst-srm:PAY_TYPE")
    @SysCode(sys = "yst-srm", mod = "PAY_TYPE")
    private String payMethod;
    private String payMethodName;
    @ApiModelProperty("默认发票类型 [UDC]COM:INV_TYPE")
    @SysCode(sys = "yst-supp", mod = "INV_TYPE")
    private String invType;
    private String invTypeName;
    @ApiModelProperty("税率编码")
    private String taxRateNo;
    @ApiModelProperty("税率名称")
    private String taxRateDesc;
    @ApiModelProperty("税率值")
    private Double taxRateValue;
    @ApiModelProperty("纳税人类型 [UDC]yst-srm:PAYER_TYPE")
    @SysCode(sys = "yst-srm", mod = "PAYER_TYPE")
    private String taxPayerType;
    private String taxPayerTypeName;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("公司ID")
    private Long ouId;

    @ApiModelProperty("内部交易公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId2;
    @ApiModelProperty("内部交易公司编码")
    private String ouCode2;

    @ApiModelProperty("代理编号")
    private String agencyCode;

    @ApiModelProperty("币种")
    String currCode;

    @ApiModelProperty("纳税人识别号")
    private String taxPayerId;
}
