package com.elitesland.srm.iam.service;

import com.elitesland.srm.iam.domain.SrmIamExtInfo;
import com.elitesland.yst.security.CurrentUserExtension;
import com.elitesland.yst.security.entity.GeneralUserDetails;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * @author eric.hao
 * @since 2022/03/29
 */
@Slf4j
@Component
public class SrmIamExtService implements CurrentUserExtension<SrmIamExtInfo> {

    /**
     * 当前是通过拦截器实现，所以每次接口调用都会执行一次
     * 服务器性能问题，方案待商榷
     *
     * @param currentUser 当前登录用户
     */
    @Override
    public SrmIamExtInfo extension(GeneralUserDetails currentUser) {
        logger.debug("[SRM-IAM] query iam extension info.");
        SrmIamExtInfo extInfo = new SrmIamExtInfo();
        // TODO 供应商信息
        return extInfo;
    }
}
