package com.elitesland.srm.sms.config;

import lombok.Data;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Data
@Configuration
public class MobileSmsProperties {

    /**
     * 有效时间
     */
    @Value("${mobile.smskaptch.validTime:60}")
    private Long validTime;

    /**
     * 验证码长度
     */
    @Value("${mobile.smskaptch.kaptchaLength:4}")
    private Integer captchaLength;

    /**
     * 短信内容占位信息
     */
    @Value("${mobile.smskaptch.formatContent:'短信验证码{0},有效期60秒'}")
    private String formatContent;

    /**
     * 开启模拟短信-测试使用不真的发送  默认关闭 需要使用true
     */
    @Value("${mobile.smskaptch.enabledTest:true}")
    private Boolean enabledTest;
}
