package com.elitesland.srm.sms.service;

import cn.hutool.http.HttpStatus;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import com.elitesland.srm.sms.config.MobileSmsProperties;
import com.elitesland.srm.sms.util.SmsUtil;
import com.elitesland.srm.util.error.SrmException;
import com.elitesland.yst.common.util.RedisUtils;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;

/**
 * @author eric.hao
 * @since 2023/01/05
 */
@Slf4j
@Service
@RequiredArgsConstructor
@UnicomTag("GENERAL")
public class SmsServiceImpl implements SmsService {

    @Autowired
    private MobileSmsProperties mobileSmsProperties;
    @Autowired
    private RedisUtils redisClient;

    @Override
    public void sendRegisterVerifyCode(String mobile) throws IOException {
        String verifyKey = SmsUtil.registerKey(mobile);
        // 校验是否重复发送
        Object captchaCache = redisClient.get(verifyKey);
        if (captchaCache != null) {
            throw SrmException.businessException("验证码未失效：有效时间 " + mobileSmsProperties.getValidTime() + " 秒");
        }

        // 生成新验证码
        String captcha = SmsUtil.generateCaptcha(mobileSmsProperties.getCaptchaLength());
        logger.info("[SRM-SMS] register generate mobile({}), captcha({})", mobile, captcha);
        // 测试
        if (mobileSmsProperties.getEnabledTest()) {
            redisClient.set(verifyKey, captcha, mobileSmsProperties.getValidTime());
            return;
        }
        // 正式
        var response = SmsUtil.send(mobile, captcha);
        if (response.getCode() != HttpStatus.HTTP_OK) {
            throw SrmException.businessException("验证码发送失败：" + response.getCode());
        }
        redisClient.set(verifyKey, captcha, mobileSmsProperties.getValidTime());
    }
}
