package com.elitesland.srm.sms.util;

import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicNameValuePair;

import java.io.IOException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;

/**
 * @author eric.hao
 * @since 2023/01/05
 */
public class SmsUtil {

    private final static SimpleDateFormat SERIAL_FORMAT = new SimpleDateFormat("yyyyMMddHHmmssSSS");
    private final static Charset CHARSET_GBK = Charset.forName("gbk");

    /**
     * 注册短信验证码
     */
    public final static String REGISTER_MOBILE_SMS_VERIFY_CODE = "RegisterMobileSmsVerifyCode";

    public static String registerKey(String mobile) {
        return REGISTER_MOBILE_SMS_VERIFY_CODE + ":" + mobile;
    }

    /**
     * 发送短信 - 参数构造
     *
     * @param mobile  手机号
     * @param captcha 验证码
     * @return 构造参数
     */
    public static List<NameValuePair> builder(String mobile, String captcha) {
        List<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add(new BasicNameValuePair("SpCode", "246212"));
        params.add(new BasicNameValuePair("LoginName", "jx_zjdm"));
        params.add(new BasicNameValuePair("Password", "zjdm2217"));
        params.add(new BasicNameValuePair("MessageContent", "尊敬的客户您好，您本次的验证码为：" + captcha));
        params.add(new BasicNameValuePair("UserNumber", mobile));
        params.add(new BasicNameValuePair("SerialNumber", "000" + SERIAL_FORMAT.format(new Date())));
        params.add(new BasicNameValuePair("ScheduleTime", ""));
        params.add(new BasicNameValuePair("ExtendAccessNum", ""));
        params.add(new BasicNameValuePair("f", "1"));
        return params;
    }

    /**
     * 发送短信验证码
     *
     * @param mobile  手机号
     * @param captcha 验证码
     * @return 发送结果
     */
    public static CloseableHttpResponse send(String mobile, String captcha) throws IOException {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpPost post = new HttpPost("http://api.ums86.com:8888/sms/Api/Send.do");
        List<NameValuePair> formParam = SmsUtil.builder(mobile, captcha);
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(formParam, CHARSET_GBK);
        post.setEntity(entity);
        // 发送请求并获取返回结果
        return httpclient.execute(post);
    }

    /**
     * 生成短信验证码
     *
     * @param length 验证码长度
     */
    public static String generateCaptcha(int length) {
        StringBuilder str = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < length; i++) {
            // 生成一个[0,10)
            int randomInt = random.nextInt(9);
            str.append(randomInt);
        }
        return str.toString();
    }
}
