package com.elitesland.srm.supplier.biz.service;

import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import com.elitesland.srm.supplier.biz.vo.save.SuppSaveParam;
import com.elitesland.srm.supplier.record.archive.addr.service.SuppAddrService;
import com.elitesland.srm.supplier.record.archive.addtion.service.SuppAdditionService;
import com.elitesland.srm.supplier.record.archive.contact.service.SuppContactService;
import com.elitesland.srm.supplier.record.archive.finance.service.SuppFinanceService;
import com.elitesland.srm.supplier.record.archive.ou.service.SuppOuService;
import com.elitesland.srm.supplier.record.archive.qualify.service.SuppQualifyService;
import com.elitesland.srm.supplier.record.archive.supp.service.SupplierService;
import com.elitesland.srm.supplier.record.archive.user.service.SuppUserService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * @author eric.hao
 * @since 2022/11/10
 */
@Slf4j
@Service
@RequiredArgsConstructor
@UnicomTag("GENERAL")
public class SuppBizServiceImpl implements SuppBizService<SuppSaveParam> {

    private final SupplierService suppService;
    private final SuppAdditionService suppAdditionService;
    private final SuppOuService suppOuService;
    private final SuppAddrService suppAddrService;
    private final SuppContactService suppContactService;
    private final SuppFinanceService suppFinanceService;
    private final SuppQualifyService suppQualifyService;
    private final SuppUserService suppUserService;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public long saveSupp(SuppSaveParam saveParam) {
        // 新建供应商主数据
        long suppId = suppService.saveSupp(saveParam);
        saveParam.setId(suppId);
        // 扩展字段
        suppAdditionService.saveSuppAddition(saveParam);
        // 关联子公司
        suppOuService.saveSuppOu(saveParam);
        // 地址簿
        suppAddrService.saveAddr(saveParam);
        // 联系人
        suppContactService.saveContact(saveParam);
        // 财务信息(包括银行账号)
        suppFinanceService.saveFinance(saveParam);
        // 资质证照
        suppQualifyService.saveQualify(saveParam);
        // 创建账号
        suppUserService.saveSuppUser(saveParam);
        return suppId;
    }
}
