package com.elitesland.srm.supplier.biz.service;

import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import com.elitesland.srm.sms.util.SmsUtil;
import com.elitesland.srm.supplier.record.archive.supp.repo.SupplierRepoProc;
import com.elitesland.srm.supplier.register.vo.save.SuppRegisterSaveParam;
import com.elitesland.srm.util.error.SrmException;
import com.elitesland.yst.common.util.RedisUtils;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author eric.hao
 * @since 2022/12/26
 */
@Slf4j
@Service
@RequiredArgsConstructor
@UnicomTag("GENERAL")
public class SuppValidateServiceImpl implements SuppValidateService<SuppRegisterSaveParam> {

    @Autowired
    private RedisUtils redisClient;
    private final SupplierRepoProc supplierRepoProc;

    @Override
    public boolean checkMobileSmsCaptcha(String mobile, String captcha) {
        Object value = redisClient.get(SmsUtil.registerKey(mobile));
        return ObjectUtil.equals(value, captcha);
    }

    @Override
    public boolean registerValidate(SuppRegisterSaveParam saveParam) {
        // 1. 验证码无效
        boolean validTag = checkMobileSmsCaptcha(saveParam.getMobile(), saveParam.getCaptcha());
        if (!validTag) {
            throw SrmException.businessException("验证码错误");
        }
        // 2. 两次输入密码不相同
        if (ObjectUtil.notEqual(saveParam.getPassword(), saveParam.getPassword2())) {
            throw SrmException.businessException("两次输入密码不相同");
        }
        return true;
    }

    @Override
    public boolean existsBySuppName(Long suppId, String suppName) {
        return supplierRepoProc.existsBySuppName(suppId, suppName);
    }
}
