package com.elitesland.srm.supplier.biz.vo.save;

import cn.hutool.core.util.ObjectUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author eric.hao
 * @since 2022/12/26
 */
@Data
@ApiModel("供应商保存参数")
public class SuppSaveParam {

    @ApiModelProperty("供应商ID")
    private Long id;

    @ApiModelProperty("供应商编码")
    private String suppCode;

    @ApiModelProperty("供应商名称")
    private String suppName;

    @ApiModelProperty("手机号")
    private String mobile;

    @ApiModelProperty("邮箱")
    private String email;

    @ApiModelProperty("公司ID")
    private Long ouId;

    @ApiModelProperty("登录密码")
    private String password;

    /**
     * 是否新建
     */
    public boolean isNew() {
        return ObjectUtil.isEmpty(id);
    }
}
