package com.elitesland.srm.supplier.record.archive.addtion.convert;

import com.elitesland.srm.supplier.biz.vo.save.SuppSaveParam;
import com.elitesland.srm.supplier.record.archive.addtion.entity.SuppAddDO;
import com.elitesland.yst.core.common.BaseMapperConfig;
import org.mapstruct.*;
import org.mapstruct.factory.Mappers;

/**
 * @author eric.hao
 * @since 2023/01/03
 */
@Mapper(config = BaseMapperConfig.class)
public interface SuppAddConvert {

    SuppAddConvert INSTANCE = Mappers.getMapper(SuppAddConvert.class);

    /**
     * 注册新增
     *
     * @param saveParam 保存参数
     * @return
     */
    SuppAddDO createToDO(SuppSaveParam saveParam);

    /**
     * 参数更新到DO
     *
     * @param saveParam 更新参数
     * @param suppAddDO 原始数据
     */
    @Mapping(target = "id", ignore = true)
    @BeanMapping(nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.IGNORE)
    void updateToDO(SuppSaveParam saveParam, @MappingTarget SuppAddDO suppAddDO);
}
