package com.elitesland.srm.supplier.record.archive.addtion.repo;

import com.elitesland.srm.supplier.record.archive.addtion.entity.SuppAddDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;

import java.util.Optional;

/**
 * 基础信息补充表
 *
 * @author eric.hao
 * @since 2023/01/03
 */
public interface SuppAddRepo extends JpaRepository<SuppAddDO, Long>, QuerydslPredicateExecutor<SuppAddDO> {

    /**
     * 查询供应商补充信息
     *
     * @param suppId 供应商id
     * @return 补充信息
     */
    Optional<SuppAddDO> findBySuppId(long suppId);
}
