package com.elitesland.srm.supplier.record.archive.addtion.service;

import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import com.elitesland.srm.supplier.biz.vo.save.SuppSaveParam;
import com.elitesland.srm.supplier.record.archive.addtion.convert.SuppAddConvert;
import com.elitesland.srm.supplier.record.archive.addtion.entity.SuppAddDO;
import com.elitesland.srm.supplier.record.archive.addtion.repo.SuppAddRepo;
import com.elitesland.srm.supplier.record.archive.addtion.repo.SuppAddRepoProc;
import com.elitesland.srm.util.error.SrmException;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Optional;

/**
 * @author eric.hao
 * @since 2022/12/26
 */
@Slf4j
@Service
@AllArgsConstructor
@UnicomTag("GENERAL")
public class SuppAdditionServiceImpl implements SuppAdditionService<SuppSaveParam> {

    private final SuppAddRepo suppAddRepo;
    private final SuppAddRepoProc suppAddRepoProc;

    @Override
    public void saveSuppAddition(SuppSaveParam saveParam) {
        if (saveParam.isNew()) {
            throw SrmException.businessException("找不到正确的供应商");
        }

        // 新增
        SuppAddDO suppAddDO;
        var suppAddOpt = findBySuppId(saveParam.getId());
        if (suppAddOpt.isEmpty()) {
            suppAddDO = SuppAddConvert.INSTANCE.createToDO(saveParam);
        }
        // 覆盖更新
        else {
            suppAddDO = suppAddOpt.get();
            SuppAddConvert.INSTANCE.updateToDO(saveParam, suppAddDO);
        }
        suppAddRepo.save(suppAddDO);
    }

    @Override
    public Optional<SuppAddDO> findBySuppId(long suppId) {
        return suppAddRepo.findBySuppId(suppId);
    }
}
