package com.elitesland.srm.supplier.record.archive.cfg.entity;

import com.elitesland.yst.common.base.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.Comment;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 供应商配置表
 *
 * @author eric.hao
 * @since 2022/11/09
 */
@Entity
@Table(name = "srm_supp_config")
@org.hibernate.annotations.Table(appliesTo = "srm_supp_config", comment = "供应商配置表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class SrmSuppCfg extends BaseModel implements Serializable {

    @Comment(value = "供应商ID")
    @Column()
    private Long suppId;

    @Comment(value = "供应商编码")
    @Column()
    private String suppCode;

    @Comment(value = "供应商名称")
    @Column()
    private String suppName;

    @Comment(value = "是否参与考核")
    @Column()
    private boolean isExamine;

    @Comment(value = "是否自动对账")
    @Column()
    private boolean isAutoAccount;

    @Comment(value = "允许分公司询价")
    @Column()
    private boolean isInquiry;
}
