package com.elitesland.srm.supplier.record.archive.ou.service;

import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import com.elitesland.srm.supplier.biz.vo.save.SuppSaveParam;
import com.elitesland.srm.supplier.record.archive.addtion.convert.SuppAddConvert;
import com.elitesland.srm.supplier.record.archive.addtion.entity.SuppAddDO;
import com.elitesland.srm.supplier.record.archive.ou.convert.SuppOuConvert;
import com.elitesland.srm.supplier.record.archive.ou.entity.SuppOuDO;
import com.elitesland.srm.supplier.record.archive.ou.repo.SuppOuRepo;
import com.elitesland.srm.supplier.record.archive.ou.repo.SuppOuRepoProc;
import com.elitesland.srm.util.error.SrmException;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Optional;

/**
 * @author eric.hao
 * @since 2022/12/26
 */
@Slf4j
@Service
@AllArgsConstructor
@UnicomTag("GENERAL")
public class SuppOuServiceImpl implements SuppOuService<SuppSaveParam> {

    private final SuppOuRepo suppOuRepo;
    private final SuppOuRepoProc suppOuRepoProc;

    @Override
    public void saveSuppOu(SuppSaveParam saveParam) {
        if (saveParam.isNew()) {
            throw SrmException.businessException("找不到正确的供应商");
        }
        // 存在关联公司，则进行保存
        if (ObjectUtil.isNotNull(saveParam.getOuId())) {
            // 新增
            SuppOuDO suppOuDO;
            var suppOuOpt = queryOneBy(saveParam.getId(), saveParam.getOuId());
            if (suppOuOpt.isEmpty()) {
                suppOuDO = SuppOuConvert.INSTANCE.createToDO(saveParam);
            }
            // 覆盖更新
            else {
                suppOuDO = suppOuOpt.get();
                SuppOuConvert.INSTANCE.updateToDO(saveParam, suppOuDO);
            }
            suppOuRepo.save(suppOuDO);
        }
    }

    private Optional<SuppOuDO> queryOneBy(Long suppId, Long ouId) {
        return suppOuRepo.findBySuppIdAndOuId(suppId, ouId);
    }
}
