package com.elitesland.srm.supplier.record.archive.supp.convert;

import com.elitesland.srm.supplier.biz.vo.save.SuppSaveParam;
import com.elitesland.srm.supplier.record.archive.supp.entity.SupplierDO;
import com.elitesland.yst.core.common.BaseMapperConfig;
import org.mapstruct.*;
import org.mapstruct.factory.Mappers;

/**
 * @author eric.hao
 * @since 2022/12/26
 */
@Mapper(config = BaseMapperConfig.class)
public interface SuppSaveConvert {

    SuppSaveConvert INSTANCE = Mappers.getMapper(SuppSaveConvert.class);

    /**
     * 新建供应商：类型转换
     *
     * @param saveParam 保存参数
     * @return 转换后参数
     */
    SupplierDO saveParamToDO(SuppSaveParam saveParam);

    /**
     * 更新供应商：参数更新到DO
     *
     * @param saveParam 更新参数
     * @param suppDO    供应商原始数据
     */
    @Mapping(target = "id", ignore = true)
    @BeanMapping(nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.IGNORE)
    void updateToDO(SuppSaveParam saveParam, @MappingTarget SupplierDO suppDO);
}
