package com.elitesland.srm.supplier.record.archive.supp.repo;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitesland.srm.supplier.record.archive.supp.entity.QSupplierDO;
import com.elitesland.srm.supplier.record.archive.supp.vo.resp.SrmSuppRespVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @author eric.hao
 * @since 2022/03/23
 */
@Component
@RequiredArgsConstructor
public class SupplierRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private static final QSupplierDO Q_SRM_SUPP_DO = QSupplierDO.supplierDO;

    /**
     * 供应商名称是否重复
     *
     * @param suppId   供应商id
     * @param suppName 供应商名称
     */
    public boolean existsBySuppName(Long suppId, String suppName) {
        JPAQuery<SrmSuppRespVO> query = jpaQueryFactory.select(Projections.bean(
                SrmSuppRespVO.class,
                Q_SRM_SUPP_DO.id
        )).from(Q_SRM_SUPP_DO);
        List<Predicate> predicates = new ArrayList<>();
        if (ObjectUtil.isNotEmpty(suppId)) {
            predicates.add(Q_SRM_SUPP_DO.id.ne(suppId));
        }
        predicates.add(Q_SRM_SUPP_DO.suppName.eq(suppName));
        query.where(ExpressionUtils.allOf(predicates));
        return CollUtil.isNotEmpty(query.fetch());
    }
}
