package com.elitesland.srm.supplier.record.archive.supp.service;

import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import com.elitesland.srm.supplier.biz.vo.save.SuppSaveParam;
import com.elitesland.srm.supplier.record.archive.supp.convert.SuppSaveConvert;
import com.elitesland.srm.supplier.record.archive.supp.entity.SupplierDO;
import com.elitesland.srm.supplier.record.archive.supp.repo.SupplierRepo;
import com.elitesland.srm.supplier.record.archive.supp.repo.SupplierRepoProc;
import com.elitesland.srm.util.error.SrmException;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Optional;

/**
 * @author eric.hao
 * @since 2022/03/16
 */
@Slf4j
@Service
@AllArgsConstructor
@UnicomTag("GENERAL")
public class SupplierServiceImpl implements SupplierService<SuppSaveParam> {

    private final SupplierRepo supplierRepo;
    private final SupplierRepoProc supplierRepoProc;

    @Override
    public long saveSupp(SuppSaveParam saveParam) {
        // 新建供应商主数据
        if (saveParam.isNew()) {
            var suppDO = SuppSaveConvert.INSTANCE.saveParamToDO(saveParam);
            supplierRepo.save(suppDO);
            return suppDO.getId();
        }

        // 修改供应商
        var suppOpt = findById(saveParam.getId());
        if (suppOpt.isEmpty()) {
            throw SrmException.parameterException("找不到正确的供应商：" + saveParam.getId());
        }
        var suppDO = suppOpt.get();
        SuppSaveConvert.INSTANCE.updateToDO(saveParam, suppDO);
        supplierRepo.save(suppDO);
        return suppDO.getId();
    }

    @Override
    public Optional<SupplierDO> findById(long suppId) {
        return supplierRepo.findById(suppId);
    }
}
