package com.elitesland.srm.supplier.record.archive.user.repo;

import com.elitesland.srm.supplier.record.archive.supp.entity.QSupplierDO;
import com.elitesland.srm.supplier.record.archive.user.entity.QSuppUserDO;
import com.elitesland.srm.supplier.record.archive.user.vo.resp.SuppUserVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @author eric.hao
 * @since 2023/01/03
 */
@Component
@RequiredArgsConstructor
public class SuppUserRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private static final QSupplierDO Q_SUPPLIER_DO = QSupplierDO.supplierDO;
    private static final QSuppUserDO Q_SUPP_USER_DO = QSuppUserDO.suppUserDO;

    private final QBean<SuppUserVO> suppUserVO = Projections.bean(
            SuppUserVO.class,
            Q_SUPP_USER_DO.sysUserId,
            Q_SUPP_USER_DO.username,
            Q_SUPP_USER_DO.suppId,
            Q_SUPPLIER_DO.suppCode,
            Q_SUPPLIER_DO.suppName
    );

    public SuppUserVO findBySysUserId(Long sysUserId) {
        var jpaQuery = jpaQueryFactory.select(suppUserVO)
                .from(Q_SUPP_USER_DO)
                .leftJoin(Q_SUPPLIER_DO).on(Q_SUPPLIER_DO.id.eq(Q_SUPP_USER_DO.suppId));
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(Q_SUPP_USER_DO.sysUserId.eq(sysUserId));
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        return jpaQuery.fetchOne();
    }
}
