package com.elitesland.srm.supplier.record.archive.user.service;

import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import com.elitesland.srm.iam.service.IamUserService;
import com.elitesland.srm.supplier.biz.vo.save.SuppSaveParam;
import com.elitesland.srm.supplier.record.archive.user.entity.SuppUserDO;
import com.elitesland.srm.supplier.record.archive.user.repo.SuppUserRepo;
import com.elitesland.srm.supplier.record.archive.user.repo.SuppUserRepoProc;
import com.elitesland.srm.supplier.record.archive.user.vo.resp.SuppUserVO;
import com.elitesland.srm.util.error.SrmException;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @author eric.hao
 * @since 2022/12/26
 */
@Slf4j
@Service
@AllArgsConstructor
@UnicomTag("GENERAL")
public class SuppUserServiceImpl implements SuppUserService<SuppSaveParam> {

    private final IamUserService iamUserService;
    private final SuppUserRepo suppUserRepo;
    private final SuppUserRepoProc suppUserRepoProc;

    private SuppUserVO findBySysUserId(Long sysUserId) {
        return suppUserRepoProc.findBySysUserId(sysUserId);
    }

    @Override
    public boolean existsSuppUser(Long suppId, Long sysUserId) {
        SuppUserVO suppUserVO = findBySysUserId(sysUserId);
        if (ObjectUtil.isNull(suppUserVO)) {
            return false;
        }
        if (!suppUserVO.getSuppId().equals(suppId)) {
            throw SrmException.businessException("编辑失败，用户已绑定其他供应商");
        }
        return true;
    }

    @Override
    public void saveSuppUser(SuppSaveParam saveParam) {
        // 创建账号
        Long userId = iamUserService.createSuppUser(saveParam);
        // 不存在 -> 新增
        if (!existsSuppUser(saveParam.getId(), userId)) {
            SuppUserDO suppUserDO = new SuppUserDO();
            suppUserDO.setSysUserId(userId);
            suppUserDO.setSuppId(saveParam.getId());
            suppUserDO.setEnabled(1);
            suppUserRepo.save(suppUserDO);
        }
    }
}
